//
//  ViewController.m
//  yysdkDemo
//
//  Created by chenzx on 2018/10/9.
//  Copyright © 2018年 Chenzx. All rights reserved.
//

#import "ViewController.h"
#import <YY3733NewSDK/YYSDKApi.h>

@interface ViewController ()

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    CGFloat width = self.view.frame.size.width;
    
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = CGRectMake(20, 40, width - 40, 40);
    btn.layer.cornerRadius = 4.f;
    btn.clipsToBounds = YES;
    [btn setTitle:@"支付" forState:UIControlStateNormal];
    [btn setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [btn setBackgroundImage:[self createImageWithColor:[UIColor lightGrayColor]] forState:UIControlStateNormal];
    [btn setBackgroundImage:[self createImageWithColor:[UIColor grayColor]] forState:UIControlStateHighlighted];
    [self.view addSubview:btn];
    [btn addTarget:self action:@selector(toPay) forControlEvents:UIControlEventTouchUpInside];
    
    UIButton *btn2 = [UIButton buttonWithType:UIButtonTypeCustom];
    btn2.frame = CGRectMake(20, 40 + 40 + 20, width - 40, 40);
    [btn2 setTitle:@"登录" forState:UIControlStateNormal];
    btn2.layer.cornerRadius = 4.f;
    btn2.clipsToBounds = YES;
    [btn2 setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [btn2 setBackgroundImage:[self createImageWithColor:[UIColor lightGrayColor]] forState:UIControlStateNormal];
    [btn2 setBackgroundImage:[self createImageWithColor:[UIColor grayColor]] forState:UIControlStateHighlighted];
    [self.view addSubview:btn2];
    [btn2 addTarget:self action:@selector(toLogin) forControlEvents:UIControlEventTouchUpInside];
    
    UIButton *btn1 = [UIButton buttonWithType:UIButtonTypeCustom];
    btn1.frame = CGRectMake(20, 40 + 40 + 20 + 40 + 20, width - 40, 40);
    [btn1 setTitle:@"登出" forState:UIControlStateNormal];
    btn1.layer.cornerRadius = 4.f;
    btn1.clipsToBounds = YES;
    [btn1 setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [btn1 setBackgroundImage:[self createImageWithColor:[UIColor lightGrayColor]] forState:UIControlStateNormal];
    [btn1 setBackgroundImage:[self createImageWithColor:[UIColor grayColor]] forState:UIControlStateHighlighted];
    [self.view addSubview:btn1];
    [btn1 addTarget:self action:@selector(toLogout) forControlEvents:UIControlEventTouchUpInside];
    
    UIButton *btn3 = [UIButton buttonWithType:UIButtonTypeCustom];
    btn3.frame = CGRectMake(20, 40 + 40 + 20 + 40 + 20 + 40 + 20, width - 40, 40);
    [btn3 setTitle:@"上传角色" forState:UIControlStateNormal];
    btn3.layer.cornerRadius = 4.f;
    btn3.clipsToBounds = YES;
    [btn3 setTitleColor:[UIColor blackColor] forState:UIControlStateNormal];
    [btn3 setBackgroundImage:[self createImageWithColor:[UIColor lightGrayColor]] forState:UIControlStateNormal];
    [btn3 setBackgroundImage:[self createImageWithColor:[UIColor grayColor]] forState:UIControlStateHighlighted];
    [self.view addSubview:btn3];
    [btn3 addTarget:self action:@selector(toUpRole) forControlEvents:UIControlEventTouchUpInside];
    
    
    //悬浮框里面的切换账号回调，做显示登录框操作
    [YYSDKApi registerOnLogoutNotifyListener:^(NSDictionary *responseDic) {
        NSString *msg = responseDic[@"msg"];
        NSLog(@"2----------------2登出%@",msg);
    }];
    
}

- (UIImage*)createImageWithColor: (UIColor *) color {
    
    CGRect rect=CGRectMake(0.0f, 0.0f, 1.0f, 1.0f);
    
    UIGraphicsBeginImageContext(rect.size);
    
    CGContextRef context = UIGraphicsGetCurrentContext();
    
    CGContextSetFillColorWithColor(context, [color CGColor]);
    
    CGContextFillRect(context, rect);
    
    UIImage *theImage = UIGraphicsGetImageFromCurrentImageContext();
    
    UIGraphicsEndImageContext();
    
    return theImage;
    
}

- (void)toLogin {
    
    //弹出登录框
    [YYSDKApi showLoginWithCallBack:^(NSDictionary *responseDic) {
        NSLog(@"login:::::::::::::%@",responseDic);
    }];
    
}

- (void)toLogout {
    [YYSDKApi logoutWithCallBack:^(NSDictionary *responseDic) {
        NSString *msg = responseDic[@"msg"];
        NSLog(@"1----------------1登出%@",msg);
    }];
}

- (void)toUpRole {
    NSDictionary *param = @{key_role_roleId : @"123456",
                                key_role_roleName : @"测试名称2",
                                key_role_roleAreaName : @"测试区服名称3",
                                key_role_roleAreaId : @"888888",
                                key_role_roleLevel : @"100",
                                };
    [YYSDKApi submitRoleInfo:param];
}

- (void)toPay {
    
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:nil message:@"请输入支付金额" preferredStyle:UIAlertControllerStyleAlert];
    
    [alertController addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil]];
    [alertController addAction:[UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        UITextField *userNameTextField = alertController.textFields.firstObject;
        
        NSDictionary *param = @{key_yysdk_server : @"testserver",
                                key_yysdk_productName : @"元宝",
                                key_yysdk_productdesc : @"goodsdes",
                                key_yysdk_Attach : @"testattach",
                                key_yysdk_amount : userNameTextField.text,
                                key_yysdk_roleId : @"testrole",
                                };
        
        
        [YYSDKApi payOrder:param withSuccessedCallback:^(NSDictionary *responseDic) {
            NSLog(@"%@",responseDic);
            NSString *msg = responseDic[@"msg"];
            NSLog(@"0----------------0支付%@",msg);
        }];
    }]];
    [alertController addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        textField.placeholder=@"请输入支付金额";
        textField.text = @"0.01";
    }];
    
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
