//
//  YYSDKApi.h
//  sdk
//
//  Created by wyy on 2020/04/20.
//  Copyright © 2020年 Chenzx. All rights reserved.
//  2025.04.18 7.2.122版本

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

//订单参数
extern NSString * const key_yysdk_server;//角色所在的server
extern NSString * const key_yysdk_productName;//商品名字
extern NSString * const key_yysdk_productdesc;//商品描述
extern NSString * const key_yysdk_Attach;//扩展参数，没有则传空字符串
extern NSString * const key_yysdk_amount;//商品金额
extern NSString * const key_yysdk_roleId;//角色id

//上传角色参数
extern NSString * const key_role_roleId;//角色id
extern NSString * const key_role_roleName;//角色名称
extern NSString * const key_role_roleAreaName;//角色区服名称
extern NSString * const key_role_roleAreaId;//角色区服Id
extern NSString * const key_role_roleLevel;//角色等级

typedef void (^YYSDKMainThreadCallBack)(NSDictionary *responseDic);


@interface YYSDKApi : NSObject
//获取SDK版本信息
+ (NSString *)YYSDKApiVersion;
/**
 SDK初始化注册
 */
+ (void)startRegister;
/**
 唤起登录框
 @param receiverBlock 回调
 */
+ (void)showLoginWithCallBack:(YYSDKMainThreadCallBack)receiverBlock;
/**
 登出
 @param receiverBlock 回调
 */
+ (void)logoutWithCallBack:(YYSDKMainThreadCallBack)receiverBlock;
/**
 切换账号监听(退出登录)
 @param receiverBlock 回调
 */
+ (void)registerOnLogoutNotifyListener:(YYSDKMainThreadCallBack)receiverBlock;
/**
 支付
 @param param 支付参数
 @param receiverBlock 回调
 */
+ (void)payOrder:(NSDictionary *)param withSuccessedCallback:(YYSDKMainThreadCallBack)receiverBlock;

//上传角色信息
+ (void)submitRoleInfo:(NSDictionary *)param;
/**
 外部应用跳转到本应用的时候触发
 @param application application
 @param url url为必传参数
 @param sourceApplication sourceApplication
 @param annotation annotation
 */
+ (void)application:(UIApplication *)application
            openURL:(NSURL *)url
  sourceApplication:(NSString *)sourceApplication
         annotation:(id)annotation;

@end

