<?php
/**
 * 支付回调DEMO
 */

$success = "SUCCESS";
$fail    = "FAILURE";

$urldata = isset($GLOBALS["HTTP_RAW_POST_DATA"]) ? $GLOBALS["HTTP_RAW_POST_DATA"] : '';
if (empty($urldata)) {
    exit($fail);
}
$urldata = get_object_vars(json_decode($urldata));
if (empty($urldata)) {
    exit($fail);
}

$order_id     = isset($urldata['order_id']) ? $urldata['order_id'] : '';
$mem_id       = isset($urldata['mem_id']) ? $urldata['mem_id'] : '';
$app_id       = isset($urldata['app_id']) ? intval($urldata['app_id']) : 0;
$money        = isset($urldata['money']) ? $urldata['money'] : 0.00;
$order_status = isset($urldata['order_status']) ? $urldata['order_status'] : '';
$paytime      = isset($urldata['paytime']) ? intval($urldata['paytime']) : 0;
$attach       = isset($urldata['attach']) ? $urldata['attach'] : '';
$sign         = isset($urldata['sign']) ? $urldata['sign'] : '';

if (empty($order_id) || empty($mem_id) || empty($app_id) || empty($money) || empty($order_status)
    || empty($paytime) || empty($attach) || empty($sign)) {
    exit($fail);
}

$appkey = '由app_id获取appkey';//TODO
//1、验签
$paramstr    = "order_id=" . $order_id . "&mem_id=" . $mem_id . "&app_id=" . $app_id . "&money=" . $money
    . "&order_status=" . $order_status . "&paytime=" . $paytime . "&attach=" . $attach . "&app_key=" . $appkey;
$verrifysign = md5($paramstr);
if ($verrifysign != $sign) {
    exit($fail);
}

$trueMoney = '由attach获取该订单实际金额';//TODO
//2、校验订单金额，由于php浮点数精度问题，最好统一转成整数之后再对比
if (intval(round($trueMoney * 100)) != intval(round($money * 100))) {
    exit($fail);
}

exit($success);
